/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.pmod.util;

import com.ibm.hwmca.fw.servlet.pmod.util.NoStandardFormatterException;
import com.ibm.hwmca.fw.util.Trace;
import java.math.BigDecimal;
import java.math.BigInteger;

public final class ObjectFormatter {
    private static final String TRACE_MASKT = "XPMUOBFT";
    private static final String TRACE_MASKF = "XPMUOBFF";
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;

    private ObjectFormatter() {
    }

    public static Object convert(Object subject, Class desired) throws NoStandardFormatterException {
        Trace.trace(TRACE_MASKF, "ObjectFormatter.convert( " + subject + "(class=" + (subject != null ? subject.getClass().toString() : "null") + "), " + desired + " )");
        try {
            if (subject == null || desired == null) {
                return null;
            }
            if (desired == (class$java$lang$String == null ? (class$java$lang$String = ObjectFormatter.class$("java.lang.String")) : class$java$lang$String)) {
                return ObjectFormatter.convertToString(subject);
            }
            if (desired == (class$java$lang$Integer == null ? (class$java$lang$Integer = ObjectFormatter.class$("java.lang.Integer")) : class$java$lang$Integer) || desired == Integer.TYPE) {
                return ObjectFormatter.convertToInteger(subject);
            }
            if (desired == (class$java$lang$Long == null ? (class$java$lang$Long = ObjectFormatter.class$("java.lang.Long")) : class$java$lang$Long) || desired == Long.TYPE) {
                return ObjectFormatter.convertToLong(subject);
            }
            if (desired == (class$java$lang$Double == null ? (class$java$lang$Double = ObjectFormatter.class$("java.lang.Double")) : class$java$lang$Double) || desired == Double.TYPE) {
                return ObjectFormatter.convertToDouble(subject);
            }
            if (desired == (class$java$lang$Short == null ? (class$java$lang$Short = ObjectFormatter.class$("java.lang.Short")) : class$java$lang$Short) || desired == Short.TYPE) {
                return ObjectFormatter.convertToShort(subject);
            }
            if (desired == (class$java$lang$Float == null ? (class$java$lang$Float = ObjectFormatter.class$("java.lang.Float")) : class$java$lang$Float) || desired == Float.TYPE) {
                return ObjectFormatter.convertToFloat(subject);
            }
            if (desired == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = ObjectFormatter.class$("java.lang.Boolean")) : class$java$lang$Boolean) || desired == Boolean.TYPE) {
                return ObjectFormatter.convertToBoolean(subject);
            }
            if (desired == (class$java$lang$Byte == null ? (class$java$lang$Byte = ObjectFormatter.class$("java.lang.Byte")) : class$java$lang$Byte) || desired == Byte.TYPE) {
                return ObjectFormatter.convertToByte(subject);
            }
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKT, "ObjectFormatter caught exception attempting to format inbound object: " + e);
        }
        Trace.trace(TRACE_MASKT, "ObjectFormatter is unable to apply standard formatter.");
        throw new NoStandardFormatterException("ObjectFormatter is unable to find appropriate standard conversion.");
    }

    private static Byte convertToByte(Object subject) throws NoStandardFormatterException {
        if (subject instanceof Byte) {
            return (Byte)subject;
        }
        if (subject instanceof String) {
            return Byte.valueOf((String)subject);
        }
        if (subject instanceof Number) {
            return new Byte(((Number)subject).byteValue());
        }
        Trace.trace(TRACE_MASKT, "ObjectFormatter.convert() [Byte.class] Unable to apply standard formatter.");
        throw new NoStandardFormatterException("ObjectFormatter is unable to find appropriate standard conversion.");
    }

    private static Integer convertToInteger(Object subject) throws NoStandardFormatterException {
        if (subject instanceof Integer) {
            return (Integer)subject;
        }
        if (subject instanceof String) {
            return Integer.valueOf(((String)subject).trim());
        }
        if (subject instanceof Number) {
            return new Integer(((Number)subject).intValue());
        }
        Trace.trace(TRACE_MASKT, "ObjectFormatter.convert() [Integer.class] Unable to apply standard formatter.");
        throw new NoStandardFormatterException("ObjectFormatter is unable to find appropriate standard conversion.");
    }

    private static Long convertToLong(Object subject) throws NoStandardFormatterException {
        if (subject instanceof Long) {
            return (Long)subject;
        }
        if (subject instanceof String) {
            return Long.valueOf(((String)subject).trim());
        }
        if (subject instanceof Number) {
            return new Long(((Number)subject).longValue());
        }
        Trace.trace(TRACE_MASKT, "ObjectFormatter.convert() [Long.class] Unable to apply standard formatter.");
        throw new NoStandardFormatterException("ObjectFormatter is unable to find appropriate standard conversion.");
    }

    private static Double convertToDouble(Object subject) throws NoStandardFormatterException {
        if (subject instanceof Double) {
            return (Double)subject;
        }
        if (subject instanceof String) {
            return Double.valueOf(((String)subject).trim());
        }
        if (subject instanceof Number) {
            return new Double(((Number)subject).doubleValue());
        }
        Trace.trace(TRACE_MASKT, "ObjectFormatter.convert() [Double.class] Unable to apply standard formatter.");
        throw new NoStandardFormatterException("ObjectFormatter is unable to find appropriate standard conversion.");
    }

    private static Short convertToShort(Object subject) throws NoStandardFormatterException {
        if (subject instanceof Short) {
            return (Short)subject;
        }
        if (subject instanceof String) {
            return Short.valueOf(((String)subject).trim());
        }
        if (subject instanceof Number) {
            return new Short(((Number)subject).shortValue());
        }
        Trace.trace(TRACE_MASKT, "ObjectFormatter.convert() [Short.class] Unable to apply standard formatter.");
        throw new NoStandardFormatterException("ObjectFormatter is unable to find appropriate standard conversion.");
    }

    private static Float convertToFloat(Object subject) throws NoStandardFormatterException {
        if (subject instanceof Float) {
            return (Float)subject;
        }
        if (subject instanceof String) {
            return Float.valueOf(((String)subject).trim());
        }
        if (subject instanceof Number) {
            return new Float(((Number)subject).floatValue());
        }
        Trace.trace(TRACE_MASKT, "ObjectFormatter.convert() [Float.class] Unable to apply standard formatter.");
        throw new NoStandardFormatterException("ObjectFormatter is unable to find appropriate standard conversion.");
    }

    private static Boolean convertToBoolean(Object subject) throws NoStandardFormatterException {
        if (subject instanceof Boolean) {
            return (Boolean)subject;
        }
        if (subject instanceof String) {
            return Boolean.valueOf((String)subject);
        }
        Trace.trace(TRACE_MASKT, "ObjectFormatter.convert() [Boolean.class] Unable to apply standard formatter.");
        throw new NoStandardFormatterException("ObjectFormatter is unable to find appropriate standard conversion.");
    }

    private static String convertToString(Object subject) throws NoStandardFormatterException {
        if (subject instanceof String) {
            return (String)subject;
        }
        if (subject instanceof Integer) {
            return subject.toString();
        }
        if (subject instanceof Long) {
            return subject.toString();
        }
        if (subject instanceof Double) {
            return subject.toString();
        }
        if (subject instanceof Short) {
            return subject.toString();
        }
        if (subject instanceof Float) {
            return subject.toString();
        }
        if (subject instanceof Boolean) {
            return subject.toString();
        }
        if (subject instanceof Character) {
            return subject.toString();
        }
        if (subject instanceof Byte) {
            return subject.toString();
        }
        if (subject instanceof BigInteger) {
            return subject.toString();
        }
        if (subject instanceof BigDecimal) {
            return subject.toString();
        }
        if (subject instanceof int[]) {
            StringBuffer sb = new StringBuffer(123);
            int[] sub = (int[])subject;
            for (int i = 0; i < sub.length; ++i) {
                sb.append(sub[i]);
                if (i + 1 >= sub.length) continue;
                sb.append(',');
            }
            sb.append('}');
            return null;
        }
        Trace.trace(TRACE_MASKT, "ObjectFormatter.convert() [String.class] Unable to apply standard formatter.");
        throw new NoStandardFormatterException("ObjectFormatter is unable to find appropriate standard conversion.");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

